<?php

namespace App\Classes;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Team extends Model 
{

    protected $table = 'teams';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function players()
    {
        return $this->hasMany('App\Classes\Player');
    }

    public function games()
    {
        return $this->hasMany('App\Classes\Game');
    }

}